<?php require_once __DIR__ . '/lib.php'; ?>
<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?=h($title ?? SITE_NAME)?> — <?=h(SITE_NAME)?></title>
  <meta name="theme-color" content="#050505">
  <link rel="preconnect" href="https://cdn.tailwindcss.com" crossorigin>
  <script src="https://cdn.tailwindcss.com"></script>
  
<style>
  :root{
    --bg:#050505;
    --panel:#0b0b0b;
    --gold:#d4af37;
    --gold2:#f6d365;
  }
  body{ background: radial-gradient(1200px 600px at 20% 0%, rgba(212,175,55,.10), transparent 60%), var(--bg); color:#f5f5f5; }
  .gold{ color: var(--gold); }
  .gold-border{ border-color: rgba(212,175,55,.35); }
  .gold-glow{ box-shadow: 0 0 0 1px rgba(212,175,55,.25), 0 10px 30px rgba(0,0,0,.6); }
  .btn-gold{
    background: linear-gradient(135deg, rgba(212,175,55,.95), rgba(246,211,101,.95));
    color:#111; font-weight:700;
  }
  .btn-gold:hover{ filter:brightness(1.05); transform: translateY(-1px); }
  .card{ background: linear-gradient(180deg, rgba(255,255,255,.03), rgba(255,255,255,.01)); border:1px solid rgba(212,175,55,.18); }
  .muted{ color: rgba(255,255,255,.70); }
  .line{ background: linear-gradient(90deg, transparent, rgba(212,175,55,.35), transparent); height:1px; }
</style>

</head>
<body class="min-h-screen">
  <header class="sticky top-0 z-50 backdrop-blur border-b border-white/5">
    <div class="max-w-6xl mx-auto px-4 py-4 flex items-center justify-between">
      <a href="<?=h(base_url())?>" class="flex items-center gap-3">
        <div class="w-9 h-9 rounded-2xl gold-border gold-glow border flex items-center justify-center">
          <span class="text-sm font-black gold">JP</span>
        </div>
        <div>
          <div class="text-base font-extrabold tracking-wide"><?=h(SITE_NAME)?></div>
          <div class="text-xs muted -mt-0.5">Update harian • tema hitam & emas</div>
        </div>
      </a>
      <nav class="flex items-center gap-3">
        <a class="text-sm muted hover:text-white" href="<?=h(base_url())?>">List</a>
        <?php if (is_admin()): ?>
          <a class="text-sm muted hover:text-white" href="<?=h(base_url('admin/new.php'))?>">Tambah</a>
          <a class="text-sm muted hover:text-white" href="<?=h(base_url('admin/logout.php'))?>">Logout</a>
        <?php else: ?>
          <a class="text-sm muted hover:text-white" href="<?=h(base_url('admin/'))?>">Admin</a>
        <?php endif; ?>
      </nav>
    </div>
  </header>

  <main class="max-w-6xl mx-auto px-4 py-8">
