<?php
require_once __DIR__ . '/../lib.php';
require_admin();

global $allowed_mimes;
$msg = $err = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (!csrf_check()) {
    $err = 'Sesi tidak valid. Refresh halaman.';
  } else {
    $title_in = trim($_POST['title'] ?? '');
    $date_in  = trim($_POST['date'] ?? date('Y-m-d'));
    $excerpt  = trim($_POST['excerpt'] ?? '');
    $content  = trim($_POST['content'] ?? '');

    if ($title_in === '') $err = 'Judul wajib diisi.';
    else {
      $slug = slugify($title_in);
      if ($slug === '') $slug = bin2hex(random_bytes(3));

      $posts = read_posts();
      // ensure unique slug
      $base_slug = $slug;
      $n = 2;
      $existing = array_column($posts, 'slug');
      while (in_array($slug, $existing, true)) { $slug = $base_slug . '-' . $n; $n++; }

      $image_name = '';
      if (!empty($_FILES['image']['name'])) {
        [$ok, $res] = upload_image($_FILES['image'], $allowed_mimes);
        if (!$ok) { $err = $res; }
        else $image_name = $res;
      }

      if (!$err) {
        $posts[] = [
          'slug' => $slug,
          'title' => $title_in,
          'date' => $date_in,
          'excerpt' => $excerpt,
          'content' => $content,
          'image' => $image_name,
          'created_at' => time(),
        ];
        save_posts($posts);
        $msg = '✅ Post berhasil dibuat.';
      }
    }
  }
}

$title = 'Tambah Post';
include __DIR__ . '/../partials/header.php';
?>
<div class="grid lg:grid-cols-3 gap-6">
  <div class="lg:col-span-2">
    <div class="card rounded-3xl p-6 md:p-8 gold-glow">
      <h1 class="text-2xl font-extrabold">Tambah Post Harian</h1>
      <p class="muted mt-2 text-sm">Upload bukti pembayaran (gambar) + judul + tanggal.</p>

      <?php if ($msg): ?>
        <div class="mt-4 p-3 rounded-2xl border border-emerald-500/30 bg-emerald-500/10 text-sm"><?=h($msg)?> <a class="gold underline ml-2" href="<?=h(base_url())?>">Lihat list</a></div>
      <?php endif; ?>
      <?php if ($err): ?>
        <div class="mt-4 p-3 rounded-2xl border border-red-500/30 bg-red-500/10 text-sm"><?=h($err)?></div>
      <?php endif; ?>

      <form class="mt-6 space-y-4" method="post" enctype="multipart/form-data">
        <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">

        <div>
          <label class="text-sm muted">Judul</label>
          <input name="title" class="mt-1 w-full px-4 py-3 rounded-2xl bg-black/40 border gold-border focus:outline-none focus:ring-2 focus:ring-yellow-500/30" placeholder="Contoh: Bukti Withdraw (Gates of Olympus) - KocokWin" required>
        </div>

        <div class="grid md:grid-cols-2 gap-4">
          <div>
            <label class="text-sm muted">Tanggal</label>
            <input type="date" name="date" value="<?=h(date('Y-m-d'))?>" class="mt-1 w-full px-4 py-3 rounded-2xl bg-black/40 border gold-border focus:outline-none focus:ring-2 focus:ring-yellow-500/30" required>
          </div>
          <div>
            <label class="text-sm muted">Gambar (JPG/PNG/WebP, max <?=UPLOAD_MAX_MB?>MB)</label>
            <input type="file" name="image" accept=".jpg,.jpeg,.png,.webp" class="mt-1 w-full px-4 py-3 rounded-2xl bg-black/40 border gold-border focus:outline-none focus:ring-2 focus:ring-yellow-500/30">
          </div>
        </div>

        <div>
          <label class="text-sm muted">Deskripsi singkat (untuk list)</label>
          <textarea name="excerpt" rows="3" class="mt-1 w-full px-4 py-3 rounded-2xl bg-black/40 border gold-border focus:outline-none focus:ring-2 focus:ring-yellow-500/30" placeholder="Contoh: Selamat untuk ID: ***** atas kemenangan besarnya..."></textarea>
        </div>

        <div>
          <label class="text-sm muted">Konten (detail)</label>
          <textarea name="content" rows="7" class="mt-1 w-full px-4 py-3 rounded-2xl bg-black/40 border gold-border focus:outline-none focus:ring-2 focus:ring-yellow-500/30" placeholder="Tulis detail post di sini. Pisahkan paragraf dengan baris kosong."></textarea>
        </div>

        <button class="btn-gold px-6 py-3 rounded-2xl transition" type="submit">Simpan</button>
        <a class="ml-2 px-6 py-3 rounded-2xl border gold-border muted hover:text-white transition inline-block" href="<?=h(base_url())?>">Kembali</a>
      </form>
    </div>
  </div>

  <aside>
    <div class="card rounded-3xl p-6">
      <div class="text-sm gold font-semibold tracking-widest uppercase">Tools</div>
      <div class="mt-3 space-y-2 text-sm">
        <a class="block gold underline" href="<?=h(base_url())?>" target="_blank">Buka list bukti pembayaran</a>
        <a class="block muted hover:text-white" href="<?=h(base_url('admin/manage.php'))?>">Kelola post (hapus)</a>
        <div class="line my-3"></div>
        <div class="text-xs muted">
          Data: <span class="gold">data/posts.json</span><br>
          Upload: <span class="gold">uploads/</span>
        </div>
      </div>
    </div>
  </aside>
</div>
<?php include __DIR__ . '/../partials/footer.php'; ?>
