<?php
require_once __DIR__ . '/../lib.php';
require_admin();
global $allowed_mimes;

$slug = $_GET['slug'] ?? '';
$posts = read_posts();
$idx = -1;
for ($i=0; $i<count($posts); $i++) {
  if (($posts[$i]['slug'] ?? '') === $slug) { $idx = $i; break; }
}
if ($idx < 0) { header('Location: ' . base_url('admin/manage.php')); exit; }

$post = $posts[$idx];
$msg = $err = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (!csrf_check()) { $err = 'Sesi tidak valid. Refresh halaman.'; }
  else {
    $title_in = trim($_POST['title'] ?? '');
    $date_in  = trim($_POST['date'] ?? date('Y-m-d'));
    $excerpt  = trim($_POST['excerpt'] ?? '');
    $content  = trim($_POST['content'] ?? '');

    if ($title_in === '') $err = 'Judul wajib diisi.';
    else {
      // optional replace image
      if (!empty($_FILES['image']['name'])) {
        [$ok, $res] = upload_image($_FILES['image'], $allowed_mimes);
        if (!$ok) { $err = $res; }
        else {
          if (!empty($post['image'])) {
            $fp = __DIR__ . '/../uploads/' . $post['image'];
            if (is_file($fp)) @unlink($fp);
          }
          $post['image'] = $res;
        }
      }

      if (!$err) {
        $post['title'] = $title_in;
        $post['date'] = $date_in;
        $post['excerpt'] = $excerpt;
        $post['content'] = $content;
        $posts[$idx] = $post;
        save_posts($posts);
        $msg = '✅ Perubahan tersimpan.';
      }
    }
  }
}

$title = 'Edit Post';
include __DIR__ . '/../partials/header.php';
?>
<div class="max-w-3xl mx-auto">
  <div class="card rounded-3xl p-6 md:p-8 gold-glow">
    <h1 class="text-2xl font-extrabold">Edit Post</h1>
    <p class="muted mt-2 text-sm">Slug tidak berubah: <span class="gold"><?=h($slug)?></span></p>

    <?php if ($msg): ?>
      <div class="mt-4 p-3 rounded-2xl border border-emerald-500/30 bg-emerald-500/10 text-sm"><?=h($msg)?> <a class="gold underline ml-2" href="<?=h(base_url('p/'.$slug))?>" target="_blank">Lihat</a></div>
    <?php endif; ?>
    <?php if ($err): ?>
      <div class="mt-4 p-3 rounded-2xl border border-red-500/30 bg-red-500/10 text-sm"><?=h($err)?></div>
    <?php endif; ?>

    <form class="mt-6 space-y-4" method="post" enctype="multipart/form-data">
      <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">

      <div>
        <label class="text-sm muted">Judul</label>
        <input name="title" value="<?=h($post['title'] ?? '')?>" class="mt-1 w-full px-4 py-3 rounded-2xl bg-black/40 border gold-border focus:outline-none focus:ring-2 focus:ring-yellow-500/30" required>
      </div>

      <div class="grid md:grid-cols-2 gap-4">
        <div>
          <label class="text-sm muted">Tanggal</label>
          <input type="date" name="date" value="<?=h($post['date'] ?? date('Y-m-d'))?>" class="mt-1 w-full px-4 py-3 rounded-2xl bg-black/40 border gold-border focus:outline-none focus:ring-2 focus:ring-yellow-500/30" required>
        </div>
        <div>
          <label class="text-sm muted">Ganti gambar (opsional)</label>
          <input type="file" name="image" accept=".jpg,.jpeg,.png,.webp" class="mt-1 w-full px-4 py-3 rounded-2xl bg-black/40 border gold-border focus:outline-none focus:ring-2 focus:ring-yellow-500/30">
        </div>
      </div>

      <div>
        <label class="text-sm muted">Deskripsi singkat</label>
        <textarea name="excerpt" rows="3" class="mt-1 w-full px-4 py-3 rounded-2xl bg-black/40 border gold-border focus:outline-none focus:ring-2 focus:ring-yellow-500/30"><?=h($post['excerpt'] ?? '')?></textarea>
      </div>

      <div>
        <label class="text-sm muted">Konten</label>
        <textarea name="content" rows="7" class="mt-1 w-full px-4 py-3 rounded-2xl bg-black/40 border gold-border focus:outline-none focus:ring-2 focus:ring-yellow-500/30"><?=h($post['content'] ?? '')?></textarea>
      </div>

      <button class="btn-gold px-6 py-3 rounded-2xl transition" type="submit">Simpan</button>
      <a class="ml-2 px-6 py-3 rounded-2xl border gold-border muted hover:text-white transition inline-block" href="<?=h(base_url('admin/manage.php'))?>">Kembali</a>
    </form>
  </div>
</div>
<?php include __DIR__ . '/../partials/footer.php'; ?>
